# Security Policy

Wiki.js is built with security in mind. We try our absolute best to deliver secure and robust applications. However, like any software, there can be security bugs, either introduced by an update or by using an attack vector that wasn't considered when designing the software.

If you find such vulnerability, it's important to disclose it in a quick and secure manner to the developers. Follow the instructions below to report a vulnerability.

## Supported Versions

| Version | Supported          |
| ------- | ------------------ |
| 2.x.x   | :white_check_mark: |
| 1.x.x   | :x:                |

## Reporting a Vulnerability

**DO NOT CREATE AN ISSUE ON GITHUB** to report a potential vulnerability / security problem. Instead, choose one of these options:

### A) Disclose on Huntr.dev

Disclose the vulnerability on [Huntr.dev](https://huntr.dev/bounties/disclose) for the repository `https://github.com/Requarks/wiki`.

### B) Send an email

Send an email to security@requarks.io.

Include as much details as possible, such as:
- The version(s) of Wiki.js that are impacted
- How to reproduce the vulnerability (step-by-step, screenshots or a video)
- The platform / environment it occurs on (e.g. OS version, DB type + version, etc.)
- Any potential fixes or reference code you think might be helpful in resolving the issue
- Your GitHub username if you'd like to be included as a collaborator on the private fix branch

The vulnerability will be investigated ASAP. If deemed valid, a draft security advisory will be created on GitHub and you will be included as a collaborator. A fix will be worked on in a private branch to resolves the issue. Once a fix is available, the advisory will be published.
